/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei;

import codechicken.lib.gui.GuiDraw;
import codechicken.lib.vec.Rectangle4i;
import codechicken.nei.CollapsibleItems;
import codechicken.nei.FavoriteRecipes;
import codechicken.nei.ItemList;
import codechicken.nei.ItemsGrid;
import codechicken.nei.NEIClientConfig;
import codechicken.nei.NEIClientUtils;
import codechicken.nei.guihook.GuiContainerManager;
import codechicken.nei.recipe.Recipe;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.item.ItemStack;

public class ItemsPanelGrid
extends ItemsGrid<ItemsPanelGridSlot, ItemsGrid.MouseContext> {
    public ArrayList<ItemStack> newItems;
    public ArrayList<ItemStack> rawItems;
    protected List<ItemsPanelGridSlot> gridMask;
    protected final Map<Integer, Integer> itemToGroup = new HashMap<Integer, Integer>();
    protected final Map<Integer, List<ItemStack>> groupItems = new HashMap<Integer, List<ItemStack>>();
    protected boolean forceExpand = false;

    public void setItems(ArrayList<ItemStack> items) {
        this.newItems = items;
    }

    public static void updateScale() {
        SLOT_SIZE = 2 + (int)Math.ceil(8.0f * (float)NEIClientConfig.getIntSetting("inventory.itempanelScale") / 100.0f) * 2;
    }

    @Override
    public void refresh(GuiContainer gui) {
        if (this.newItems != null) {
            this.groupItems.clear();
            this.itemToGroup.clear();
            this.forceExpand = false;
            if (!CollapsibleItems.isEmpty() && !this.newItems.isEmpty()) {
                HashSet<Integer> groups = new HashSet<Integer>();
                boolean outsideGroup = false;
                this.realItems = new ArrayList();
                this.rawItems = new ArrayList<ItemStack>(this.newItems);
                for (ItemStack stack : this.newItems) {
                    int groupIndex = CollapsibleItems.getGroupIndex(stack);
                    if (groupIndex == -1) {
                        this.realItems.add(stack);
                        outsideGroup = true;
                        continue;
                    }
                    if (!groups.contains(groupIndex) || CollapsibleItems.isExpanded(groupIndex)) {
                        this.itemToGroup.put(this.realItems.size(), groupIndex);
                        this.realItems.add(stack);
                        groups.add(groupIndex);
                    }
                    this.groupItems.computeIfAbsent(groupIndex, gi -> new ArrayList()).add(stack);
                }
                if (!outsideGroup && groups.size() == 1) {
                    int groupIndex = (Integer)groups.iterator().next();
                    this.realItems = new ArrayList<ItemStack>(this.newItems);
                    this.itemToGroup.clear();
                    this.forceExpand = true;
                    for (int itemIndex = 0; itemIndex < this.realItems.size(); ++itemIndex) {
                        this.itemToGroup.put(itemIndex, groupIndex);
                    }
                }
            } else {
                this.realItems = new ArrayList<ItemStack>(this.newItems);
            }
            this.newItems = null;
            this.onItemsChanged();
        }
        super.refresh(gui);
    }

    @Override
    protected void onGridChanged() {
        this.gridMask = null;
        super.onGridChanged();
    }

    @Override
    public List<ItemsPanelGridSlot> getMask() {
        if (this.gridMask == null) {
            this.gridMask = new ArrayList<ItemsPanelGridSlot>();
            int itemIndex = this.page * this.perPage;
            for (int slotIndex = 0; slotIndex < this.rows * this.columns && itemIndex < this.size(); ++slotIndex) {
                if (this.isInvalidSlot(slotIndex)) continue;
                this.gridMask.add(new ItemsPanelGridSlot(slotIndex, itemIndex, this.getItem(itemIndex)));
                ++itemIndex;
            }
            this.calculateGroupBorders(this.gridMask);
        }
        return this.gridMask;
    }

    @Override
    protected ItemsGrid.MouseContext getMouseContext(int mousex, int mousey) {
        ItemsPanelGridSlot hovered = (ItemsPanelGridSlot)this.getSlotMouseOver(mousex, mousey);
        if (hovered != null) {
            return new ItemsGrid.MouseContext(hovered.slotIndex, hovered.slotIndex / this.columns, hovered.slotIndex % this.columns);
        }
        return null;
    }

    protected void calculateGroupBorders(List<ItemsPanelGridSlot> gridMask) {
        if (gridMask.isEmpty() || this.groupItems.isEmpty()) {
            return;
        }
        Color collapsedBGColor = new Color(NEIClientConfig.getSetting("inventory.collapsibleItems.collapsedColor").getHexValue(), true);
        Color expandedBGColor = new Color(NEIClientConfig.getSetting("inventory.collapsibleItems.expandedColor").getHexValue(), true);
        Color collapsedBorderColor = ItemsPanelGrid.darkerColor(collapsedBGColor);
        Color expandedBorderColor = ItemsPanelGrid.darkerColor(expandedBGColor);
        HashMap<Integer, Integer> borderGrid = new HashMap<Integer, Integer>();
        for (ItemsPanelGridSlot item : gridMask) {
            borderGrid.put(item.slotIndex, this.itemToGroup.getOrDefault(item.itemIndex, -1));
        }
        for (ItemsPanelGridSlot item : gridMask) {
            int groupIndex = (Integer)borderGrid.get(item.slotIndex);
            List<ItemStack> groupItems = this.groupItems.get(groupIndex);
            if (groupItems == null || groupItems.size() == 1) continue;
            int column = item.slotIndex % this.columns;
            int row = item.slotIndex / this.columns;
            int prevSlotIndex = (row - 1) * this.columns + column;
            int nextSlotIndex = (row + 1) * this.columns + column;
            item.groupIndex = groupIndex;
            item.groupSize = groupItems.size();
            item.bgItemStack = groupItems.get(groupItems.size() - 1);
            item.displayName = CollapsibleItems.getDisplayName(groupIndex);
            item.extended = this.forceExpand || CollapsibleItems.isExpanded(groupIndex);
            item.bgColor = item.extended ? expandedBGColor : collapsedBGColor;
            item.borderColor = item.extended ? expandedBorderColor : collapsedBorderColor;
            item.borderLeft = column == 0 || borderGrid.getOrDefault(item.slotIndex - 1, -1) != groupIndex;
            item.borderRight = column + 1 == this.columns || borderGrid.getOrDefault(item.slotIndex + 1, -1) != groupIndex;
            item.borderTop = borderGrid.getOrDefault(prevSlotIndex, -1) != groupIndex;
            item.borderBottom = borderGrid.getOrDefault(nextSlotIndex, -1) != groupIndex;
        }
    }

    private static Color darkerColor(Color color) {
        return new Color(color.getRed(), color.getGreen(), color.getBlue(), Math.min((int)((float)color.getAlpha() + 102.0f), 255));
    }

    @Override
    public void draw(int mousex, int mousey) {
        if (ItemList.loadFinished) {
            super.draw(mousex, mousey);
        } else {
            GuiDraw.drawStringC((String)NEIClientUtils.cropText(GuiDraw.fontRenderer, NEIClientUtils.translate("itempanel.loading", new Object[0]), this.width - 10), (int)(this.marginLeft + this.width / 2), (int)(this.marginTop + this.height / 2), (int)0xFFFFFF, (boolean)true);
        }
    }

    public static class ItemsPanelGridSlot
    extends ItemsGrid.ItemsGridSlot {
        protected static final float LINE_WIDTH = 0.75f;
        public int groupIndex = -1;
        public String displayName = "";
        public ItemStack bgItemStack;
        public int groupSize = 1;
        public boolean extended = false;
        public Color bgColor = null;

        public ItemsPanelGridSlot(int slotIndex, int itemIndex, ItemStack itemStack) {
            super(slotIndex, itemIndex, itemStack);
        }

        public ItemStack getBGItem() {
            return this.bgItemStack;
        }

        @Override
        public Recipe.RecipeId getRecipeId() {
            return FavoriteRecipes.getFavorite(this.item);
        }

        public void beforeDraw(Rectangle4i rect, ItemsGrid.MouseContext mouseContext) {
            super.beforeDraw(rect, mouseContext);
            if (this.bgColor != null) {
                NEIClientUtils.drawRect(rect.x, rect.y, rect.w, rect.h, this.bgColor);
            }
        }

        @Override
        public void drawItem(Rectangle4i rect) {
            if (!this.extended && this.getBGItem() != null) {
                GuiContainerManager.drawItems.field_77023_b -= 10.0f;
                super.drawItem(this.getBGItem(), rect.offset(1, -1));
                GuiContainerManager.drawItems.field_77023_b += 10.0f;
                super.drawItem(this.getItemStack(), rect.offset(-2, 2));
            } else {
                super.drawItem(rect);
            }
        }
    }
}

